define(['app', 'angular'], function (app, angular) {

	app.directive('inputText', function ($timeout) {
		return {
			restrict: 'E',
			require: 'ngModel',
			scope: {
				'label': '@',
				'name': '@',
				'ngModel': '=',
				'ngDisabled': '=',
				'ngRequired': '=',
				'requiredMsg': '@',
				'ngReadonly': '=',
				'characterCounter': '=',
				'maxlength': '@',
				'rows': '@',
				'cols': '@',
				'showSecondaryLabel': '=?',
				'secondaryLabel': '@?',
				'messageLabel': '@?',
				'placeholder' : '@',
                'dontCapitalize' : "=",
                'textAreaExtra': '@',
                'onlyAlphanumeric': '=',
                'patternRegex': '=',
                'patternMsg': '@',
                'preScreenReaderLabel': '@'
			},
			link: function (scope, element, attrs, ngModelCtrl) {
				var inputArea = element.find('textarea, input');

				var label = scope.label && scope.label.replace(/:/, '').trim();

				if(scope.messageLabel) {
					var messageLabel = scope.messageLabel && scope.messageLabel.replace(/:/, '').trim();
					label = messageLabel;
				}
				scope.errorHandling = {
					'pattern': {
						message: scope.patternMsg ? scope.patternMsg : label + ' field is invalid.',
						priority: 1
					},
					'required': {
						message: scope.requiredMsg ? scope.requiredMsg : label + ' field is required.',
						priority: 2
					}
				};

			},
			controller: function ($scope) {
				var prevModel = $scope.ngModel;

				$scope.maxlength = $scope.maxlength || Infinity;

                $scope.noCap = $scope.dontCapitalize ? "off" : "on";

				$scope.charsLeft = function () {
					var string = document.getElementById('text-' + $scope.name).value
					if(string) {
						var doubleCharacters = string.match(/(\r\n|\n|\r)/g) || [];
						return $scope.maxlength - string.length - doubleCharacters.length;
					}
					return $scope.maxlength;
				};

				$scope.update = function () {
					if ($scope.ngModel && $scope.maxlength < $scope.ngModel.length) {
						$scope.ngModel = prevModel;
					}
					prevModel = $scope.ngModel;
				};
			},
			templateUrl: 'src/ui-components/form/controls/simple/input-text/input-text_template.html'
		};
	});

});
